<?php
/**
 * Chatgpt deshboard shortcode 
 *
 * @package    chatgpt_deshboard_shortcode
 * @license    GNU General Public License, version 3
 */
 
 if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

class mych_Chatgpt_Deshboard_Shortcode {

   public function __construct() {
      add_shortcode('mych_chatgpt_deshboard', array($this, 'cicg_chatgpt_deshboard_shortcode'));
    }
    
//**********************************
//     Chatgpt desboard display 
//********************************//
 function cicg_chatgpt_deshboard_shortcode(){
   ob_start();
      ?>
   <div class="cicg_chatgpt-deshboard chat-container" id="cicg_chatgpt-deshboard">
     <div class="chat-history"> 
         <nav>
            <li>
               <a href="">
                  <img class="plus-icon" src="<?php  echo esc_url( plugin_dir_url( dirname( __FILE__ )) . 'img/cicg-plus-small.png') ?>" alt="plug-icon">
                  <p><?php echo esc_html__('New Chat','caacg'); ?></p>
               </a>
            </li>
         </nav>
     </div>
     <div class="chat-body">
     <div class="chat-header">
         <h2><?php echo esc_html__('ChatGPT','caacg'); ?></h2>
         <div class="heading">
            <div class="col">
            <svg stroke="currentColor" fill="none" stroke-width="1.5" viewBox="0 0 24 24" stroke-linecap="round" stroke-linejoin="round" class="h-6 w-6" height="1.5em" width="1.5em" xmlns="http://www.w3.org/2000/svg"><circle cx="12" cy="12" r="5"></circle><line x1="12" y1="1" x2="12" y2="3"></line><line x1="12" y1="21" x2="12" y2="23"></line><line x1="4.22" y1="4.22" x2="5.64" y2="5.64"></line><line x1="18.36" y1="18.36" x2="19.78" y2="19.78"></line><line x1="1" y1="12" x2="3" y2="12"></line><line x1="21" y1="12" x2="23" y2="12"></line><line x1="4.22" y1="19.78" x2="5.64" y2="18.36"></line><line x1="18.36" y1="5.64" x2="19.78" y2="4.22"></line></svg>
               <p><?php echo esc_html__('Examples','caacg'); ?></p>
            </div>
            <div class="col">
            <svg xmlns="http://www.w3.org/2000/svg" fill="none" height="1.5em" width="1.5em" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" aria-hidden="true" class="h-6 w-6"><path stroke-linecap="round" stroke-linejoin="round" d="M3.75 13.5l10.5-11.25L12 10.5h8.25L9.75 21.75 12 13.5H3.75z"></path></svg>
               <p><?php echo esc_html__('Examples','caacg'); ?>Capabilities</p>           
            </div>
            <div class="col">
            <svg stroke="currentColor" fill="none" stroke-width="1.5"  viewBox="0 0 24 24" stroke-linecap="round" stroke-linejoin="round" class="h-6 w-6" height="1.5em" width="1.5em" xmlns="http://www.w3.org/2000/svg"><path d="M10.29 3.86L1.82 18a2 2 0 0 0 1.71 3h16.94a2 2 0 0 0 1.71-3L13.71 3.86a2 2 0 0 0-3.42 0z"></path><line x1="12" y1="9" x2="12" y2="13"></line><line x1="12" y1="17" x2="12.01" y2="17"></line></svg>
               <p><?php echo esc_html__('Examples','caacg'); ?>Limitations</p>     
            </div>
         </div>
         <div class="chat-gpt-demo">  
            <div class="col"><p><?php echo esc_html__('Explain quantum computing in simple terms','caacg'); ?></p></div>
            <div class="col"><p><?php echo esc_html__('Remembers what user said earlier in the conversation','caacg'); ?></p></div>
            <div class="col"><p><?php echo esc_html__('May occasionally generate incorrect information','caacg'); ?></p></div>
            <div class="col"><p><?php echo esc_html__('Got any creative ideas for a 10 year old’s birthday?','caacg'); ?></p></div>
            <div class="col"><p><?php echo esc_html__('Allows user to provide follow-up corrections','caacg'); ?></p></div>
            <div class="col"><p><?php echo esc_html__('May occasionally produce harmful instructions or biased content','caacg'); ?></p></div>
            <div class="col"><p><?php echo esc_html__('How do I make an HTTP request in Javascript?','caacg'); ?></p></div>
            <div class="col"><p><?php echo esc_html__('Trained to decline inappropriate requests','caacg'); ?></p></div>
            <div class="col"><p><?php echo esc_html__('Limited knowledge of world and events after 2021','caacg'); ?></p></div>    
         </div>
      </div>
      <div class="chat-message">
            <div class="chat-message-content" id="message-container">
            </div>
      </div>
      <div class="chat-footer" id="cicg_chatgpt-deshboard-footer">
         <div class="cica_chatgpt-button">
            <input type="text" id="chatgpt-text" name="chatgpt_text"placeholder="<?php echo esc_attr__( 'Type your message here...', 'caacg' ); ?>">
            <button class="cica_chatgpt-button-submit" id="cica_chatgpt-button-submit" type="submit">
               <img src="<?php  echo esc_url( plugin_dir_url( dirname( __FILE__ )) . 'img/cicg-paper-plane.png') ?>" alt="send-icon">
               <div class="cica_chatgpt-button-loader response-loader">
                  <div class="cica_chatgpt-button-spinner"></div>
               </div>
            </button>  
         </div>
      </div>
     </div>    
   </div>

      <?php
   return ob_get_clean();
}
  
}
// Instantiate the class
$my_plugin = new mych_Chatgpt_Deshboard_Shortcode();