<?php
/**
 * Class Metabox
 *
 * @package    ChatGPT-OpenAI Content Generator
 * @author     JH Fahim
 * @license    GNU General Public License, version 3
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

class mych_ChatGPT_Metabox {
    public function __construct() {

        add_action( 'add_meta_boxes', array( $this,'mych_chatgpt_add_custom_button_field') );
        add_action( 'wp_enqueue_scripts', function() {

           // wp_register_script( 'rest-uploader', plugins_url( '/assets/js/script.js', __FILE__ ), [ 'jquery' ] );
            $js_vars = [
                'endpoint' => esc_url_raw( rest_url( '/wp/v2/media/' ) ),
                'nonce'    => wp_create_nonce( 'wp_rest' ),
            ];
            wp_localize_script( 'rest-uploader', 'RestVars', $js_vars );
        } );
        

	}

   public function mych_chatgpt_add_custom_button_field() {
    $pro_licence_type = get_option('my_pro_licence_type');
	if($pro_licence_type == "elite")
	{
      add_meta_box( 'cicg_chatgpt_ai_generator_widget', 'ChatGPT AI Content Generator', 'mych_chatgpt_render_metabox_custom_field_blog', 'post', 'normal', 'default' );
      add_meta_box( 'cicg_chatgpt_ai_generator_widget', 'ChatGPT AI Content Generator', 'mych_chatgpt_render_metabox_custom_field_blog', 'page', 'normal', 'default' );
      add_meta_box( 'cicg_chatgpt_ai_generator_widget', 'ChatGPT AI Content Generator', 'mych_chatgpt_render_metabox_custom_field_woocommerce', 'product', 'normal', 'high' );
    }
  }


}

new mych_ChatGPT_Metabox();



