<?php
/**
 * Display general settings
 */
function mych_chatgpt__general_settings_display(){
   ?>
   <div class="">
      <h3><?php echo esc_html( __('ChatGPT Settings','caacg') ); ?></h3>
   </div>
   <div class="cicg_chat-gpt-general-settings">
        <form method="post" action="options.php">
            <?php settings_fields( 'cicg-chatgpt-openai-content-generator-settings-group' ); ?>
            <?php do_settings_sections( 'cicg-chatgpt-openai-content-generator-settings-group' ); ?>
            <?php 
            $cicg_api_key = esc_attr( get_option('cicg_chatgpt_api_key') );
            $cicg_api_max_tokens = esc_attr( (get_option('cicg_chatgpt_api_max_tokens')) ? get_option('cicg_chatgpt_api_max_tokens') : 4000 );
            $cicg_api_temperature = esc_attr( (get_option('cicg_api_temperature')) ? get_option('cicg_api_temperature') : 1 );
            $cicg_gpt_version = esc_attr( (get_option('cicg_gpt_version')) ? get_option('cicg_gpt_version') : 'gpt-3.5' );
            ?>
            <table class="form-table ">
                <tr valign="top">
                    <th scope="row"><?php echo esc_html( __('OpenAI API Key','caacg') ); ?></th>
                    <td>
                        <input type="text" name="cicg_chatgpt_api_key" id="chatgpt_api_key" value="<?php echo esc_attr( $cicg_api_key ); ?>" />
                        <div class="openapi-api-link">
                            <p class="description"><?php echo esc_html( __('Enter your OpenAI API key here.','caacg') ); ?></p>
                            <a href="<?php echo esc_url( 'https://platform.openai.com/account/api-keys' ); ?>"><?php echo esc_html( __('Generate Key','caacg') ); ?></a>
                        </div>
                    </td>
                </tr>
                <tr valign="top">
                    <th scope="row"><?php echo esc_html( __('GPT Version','caacg') ); ?></th>
                    <td>
                        <select name="cicg_gpt_version">
                            <option value="gpt-3.5" <?php selected( $cicg_gpt_version, 'gpt-3.5' ); ?>><?php esc_html_e( 'ChatGPT 3.5', 'caacg' ); ?></option>
                            <option value="gpt-4.0" <?php selected( $cicg_gpt_version, 'gpt-4.0' ); ?>><?php esc_html_e( 'ChatGPT 4.0', 'caacg' ); ?></option>
                            <option value="gpt-4o" <?php selected( $cicg_gpt_version, 'gpt-4o' ); ?>><?php esc_html_e( 'ChatGPT 4o', 'caacg' ); ?></option>

                        </select>
                    </td>
                </tr>                
                <tr valign="top">
                    <th scope="row"><?php echo esc_html( __('Max Tokens *','caacg') ); ?></th>
                    <td>
                        <input type="number" name="cicg_chatgpt_api_max_tokens" id="chatgpt_api_max_tokens" value="<?php echo esc_attr( $cicg_api_max_tokens ); ?>" />     
                    </td>
                </tr>
                <tr valign="top">
                    <th scope="row"><?php echo esc_html( __('Temperature','caacg') ); ?></th>
                    <td>
                        <input type="number" name="cicg_api_temperature" id="chatgpt_api_temperature" value="<?php echo esc_attr( $cicg_api_temperature ); ?>" />
                    </td>
                </tr>
                                <tr valign="top">
                    <td colspan="2">
                        <span style="color:#ff0000;">*</span> When using the different ChatGPT API versions, these are the optimal token settings:<br/>
                        7900 is for ChatGPT-4<br/>
                        3900 is for ChatGPT-3.5<br/>
                    </td>
                </tr>
            </table>
            <?php submit_button(); ?>
        </form>
   </div>


   <?php	
}
