<?php
/**
 * Display general settings
 */
function mych_ai_keyword_research(){
   ?>
   <div class="">
      <h3><?php echo esc_html( __('Keyword Research','caacg') ); ?></h3>
   </div>
   <div class="cicg_chat-gpt-keyword-research">
      <table class="form-table">
         <tr valign="top">
            <th scope="row"><?php echo esc_html( __('Enter keyword','caacg') ); ?></th>
            <td>
               <input type="text" class="keyword-input" id="keyword-input" placeholder="Enter keyword" style="width:50%; padding:10px; margin-bottom:10px;">
               <div id="empty-keyword-message" style="color: red; display: none;">Keyword cannot be empty</div>
               <div id="loading-icon" style="font-weight:bold;display: none;">Loading...</div>
            </td>
         </tr>
         <tr>
             <td colspan="2" style=""> <button id="search-keywords" class="button button-primary" style="padding:10px 20px;">Search</button>
      <textarea id="keywords-textarea" class="keywords-textarea" style="width:50%; height:200px; margin-top:10px; display:none;"></textarea>
      <button id="export-keywords" class="button button-primary" style="margin:10px 0;padding:10px 20px; display:none;">Export Keywords</button>
</td>
         </tr>
      </table>

      <script type="text/javascript">
         document.addEventListener('DOMContentLoaded', function() {
            var searchButton = document.getElementById('search-keywords');
            var keywordInput = document.getElementById('keyword-input');
            var emptyKeywordMessage = document.getElementById('empty-keyword-message');
            var loadingIcon = document.getElementById('loading-icon');
            var keywordsTextarea = document.getElementById('keywords-textarea');
            var exportButton = document.getElementById('export-keywords');

         

            searchButton.addEventListener('click', function() {
                var keyword = keywordInput.value;
                if (keyword) {
                    emptyKeywordMessage.style.display = 'none';
                    fetchKeywords(keyword);
                } else {
                    emptyKeywordMessage.style.display = 'block';
                }
            });

            function fetchKeywords(keyword) {
                loadingIcon.style.display = 'block';
                fetch('<?php echo admin_url('admin-ajax.php'); ?>?action=get_keywords&keyword=' + encodeURIComponent(keyword))
                    .then(response => response.json())
                    .then(data => {
                        loadingIcon.style.display = 'none';
                        if (data.success && Array.isArray(data.data.keywords)) {
                            displayKeywordsInTextarea(data.data.keywords);
                        } else {
                            console.error('Invalid response or no keywords found:', data);
                        }
                    })
                    .catch(error => {
                        loadingIcon.style.display = 'none';
                        console.error('Error fetching keywords:', error);
                    });
            }

            function displayKeywordsInTextarea(keywords) {
                keywordsTextarea.value = keywords.join('\n');
                keywordsTextarea.style.display = 'block';
                exportButton.style.display = 'block';
            }

            exportButton.addEventListener('click', function() {
                exportKeywordsToCSV();
            });

            function exportKeywordsToCSV() {
                var keywords = keywordsTextarea.value.split('\n');
                var csvContent = "data:text/csv;charset=utf-8," + keywords.join('\n');
                var encodedUri = encodeURI(csvContent);
                var link = document.createElement('a');
                link.setAttribute('href', encodedUri);
                link.setAttribute('download', 'keywords.csv');
                document.body.appendChild(link); // Required for FF
                link.click();
                document.body.removeChild(link);
            }
         });
      </script>
      <style>
                  @media (max-width: 767px) {
            .cicg_chat-gpt-keyword-research .keyword-input {
                width: 100% !important;
            }
            .cicg_chat-gpt-keyword-research .keywords-textarea {
                width: 100% !important;
            }
            table {
            margin-left: auto !important;
            }
                .form-table th {
                padding: 10px 0 0 !important;
                border-bottom: 0;
            }
        }
 
        .form-table th{
            margin-bottom: 9px;
            padding: 15px 10px;
            line-height: 1.3;
            vertical-align: middle;
        }
      </style>
   </div>
   <?php
}
?>