<?php
/**
 * Display metabox field for blog post
 */
function mych_chatgpt_render_metabox_custom_field_blog( $post ) {
   // Get the current post object
   global $post;
   // Get the full permalink of the current post
   $post_permalink = get_permalink( $post->ID);
   ?>
   
   <div class="cicg_section-content-api" id="cicg_section-content-api">
   
      <table class="form-table ">
         <tr valign="top">
            <th scope="row"><?php echo esc_html(__('Title','caacg')); ?></th>
            <td>
                  <input type="text" name="cicg-api-post-title" id="cicg-api-post-title" placeholder="<?php echo esc_html(__('Enter a topic for your blog title','caacg')); ?>">
                  <label class="switch cicg-product-title">
                     <input type="checkbox" class="switch-input" id="switch-post-title" checked>
                     <span class="switch-label" data-on="On" data-off="Off"></span>
                     <span class="switch-handle"></span>
                  </label>
                         <a href="#" id="keyword-research-link" style="margin-top:10px;margin-left: 10px;"><?php echo esc_html(__('Keyword Research','caacg')); ?></a>

            </td>
         </tr>
         <tr valign="top">
            <th scope="row"><?php echo esc_html(__('Description','caacg')); ?></th>
            <td>
                  <textarea name="cicg-api-post-description" id="cicg-api-post-description" cols="0" rows="3" placeholder="<?php echo esc_html(__('Enter a topic for your blog description','caacg')); ?>"></textarea>
            </td>
         </tr>
         <tr valign="top">
            <th scope="row"><?php echo esc_html(__('Content length','caacg')); ?></th>
            <td>
                  <input type="number" name="cicg_content_length" id="cicg-content-length" value="300" />
            </td>
         </tr>
         <tr valign="top">
               <th scope="row"><?php echo esc_html(__('Language','caacg')); ?></th>
               <td>
                  <label>
                  <select id="cicg-select-lenguage">
                  <option value="<?php echo esc_attr('en'); ?>"><?php echo esc_html__('English','caacg'); ?></option>
                  <option value="<?php echo esc_attr('fr'); ?>"><?php echo esc_html__('French','caacg'); ?></option>
                  <option value="<?php echo esc_attr('de'); ?>"><?php echo esc_html__('German','caacg'); ?></option>
                  <option value="<?php echo esc_attr('es'); ?>"><?php echo esc_html__('Spanish','caacg'); ?></option>
                  <option value="<?php echo esc_attr('it'); ?>"><?php echo esc_html__('Italian','caacg'); ?></option>
                  <option value="<?php echo esc_attr('pt'); ?>"><?php echo esc_html__('Portuguese','caacg'); ?></option>
                  <option value="<?php echo esc_attr('nl'); ?>"><?php echo esc_html__('Dutch','caacg'); ?></option>
                  <option value="<?php echo esc_attr('ru'); ?>"><?php echo esc_html__('Russian','caacg'); ?></option>
                  <option value="<?php echo esc_attr('ar'); ?>"><?php echo esc_html__('Arabic','caacg'); ?></option>
                  <option value="<?php echo esc_attr('zh'); ?>"><?php echo esc_html__('Chinese (Simplified)'); ?></option>
                  <option value="<?php echo esc_attr('zh-TW'); ?>"><?php echo esc_html__('Chinese (Traditional)','caacg'); ?></option>
                  <option value="<?php echo esc_attr('ja'); ?>"><?php echo esc_html__('Japanese','caacg'); ?></option>
                  <option value="<?php echo esc_attr('ko'); ?>"><?php echo esc_html__('Korean','caacg'); ?></option>
                  <option value="<?php echo esc_attr('hi'); ?>"><?php echo esc_html__('Hindi','caacg'); ?></option>
                  <option value="<?php echo esc_attr('bn'); ?>"><?php echo esc_html__('Bengali','caacg'); ?></option>
                  <option value="<?php echo esc_attr('ur'); ?>"><?php echo esc_html__('Urdu','caacg'); ?></option>
                  <option value="<?php echo esc_attr('fa'); ?>"><?php echo esc_html__('Persian (Farsi)','caacg'); ?></option>
                  <option value="<?php echo esc_attr('tr'); ?>"><?php echo esc_html__('Turkish','caacg'); ?></option>
                  <option value="<?php echo esc_attr('el'); ?>"><?php echo esc_html__('Greek','caacg'); ?></option>
                  <option value="<?php echo esc_attr('pl'); ?>"><?php echo esc_html__('Polish','caacg'); ?></option>
                  <option value="<?php echo esc_attr('cs'); ?>"><?php echo esc_html__('Czech','caacg'); ?></option>
                  <option value="<?php echo esc_attr('hu'); ?>"><?php echo esc_html__('Hungarian','caacg'); ?></option>
                  <option value="<?php echo esc_attr('fi'); ?>"><?php echo esc_html__('Finnish','caacg'); ?></option>
                  <option value="<?php echo esc_attr('sv'); ?>"><?php echo esc_html__('Swedish','caacg'); ?></option>
                  <option value="<?php echo esc_attr('no'); ?>"><?php echo esc_html__('Norwegian','caacg'); ?></option>
                  <option value="<?php echo esc_attr('da'); ?>"><?php echo esc_html__('Danish','caacg'); ?></option>
                  <option value="<?php echo esc_attr('is'); ?>"><?php echo esc_html__('Icelandic','caacg'); ?></option>
                  <option value="<?php echo esc_attr('ga'); ?>"><?php echo esc_html__('Irish','caacg'); ?></option>
                  <option value="<?php echo esc_attr('eu'); ?>"><?php echo esc_html__('Basque','caacg'); ?></option>
                  <option value="<?php echo esc_attr('et'); ?>"><?php echo esc_html__('Estonian','caacg'); ?></option>
                  <option value="<?php echo esc_attr('lv'); ?>"><?php echo esc_html__('Latvian','caacg'); ?></option>
                  <option value="<?php echo esc_attr('lt'); ?>"><?php echo esc_html__('Lithuanian','caacg'); ?></option>
                  <option value="<?php echo esc_attr('ro'); ?>"><?php echo esc_html__('Romanian','caacg'); ?></option>
                  <option value="<?php echo esc_attr('sr'); ?>"><?php echo esc_html__('Serbian','caacg'); ?></option>
                  <option value="<?php echo esc_attr('sk'); ?>"><?php echo esc_html__('Slovak','caacg'); ?></option>
                  <option value="<?php echo esc_attr('sl'); ?>"><?php echo esc_html__('Slovenian','caacg'); ?></option>
                  <option value="<?php echo esc_attr('uk'); ?>"><?php echo esc_html__('Ukrainian','caacg'); ?></option>
                  <option value="<?php echo esc_attr('hr'); ?>"><?php echo esc_html__('Croatian','caacg'); ?></option>
                  <option value="<?php echo esc_attr('bg'); ?>"><?php echo esc_html__('Bulgarian','caacg'); ?></option>

                  </select>
                  </label>
               </td>
         </tr>
         <tr valign="top">
               <th scope="row"><?php echo esc_html(__('Writing Style','caacg')) ?></th>
               <td>
               <select name="cicg_writing_style" id="cicg-writing-style">
                  <option value="<?php echo esc_attr('formal'); ?>"><?php echo esc_html__('Formal','caacg'); ?></option>
                  <option value="<?php echo esc_attr('informal'); ?>"><?php echo esc_html__('Informal','caacg'); ?></option>
                  <option value="<?php echo esc_attr('technical'); ?>"><?php echo esc_html__('Technical','caacg'); ?></option>
                  <option value="<?php echo esc_attr('creative'); ?>"><?php echo esc_html__('Creative','caacg'); ?></option>
                  <option value="<?php echo esc_attr('professional'); ?>"><?php echo esc_html__('Professional','caacg'); ?></option>
                  <option value="<?php echo esc_attr('persuasive'); ?>"><?php echo esc_html__('Persuasive','caacg'); ?></option>
                  <option value="<?php echo esc_attr('narrative'); ?>"><?php echo esc_html__('Narrative','caacg'); ?></option>
                  <option value="<?php echo esc_attr('humorous'); ?>"><?php echo esc_html__('Humorous','caacg'); ?></option>
                  <option value="<?php echo esc_attr('educational'); ?>"><?php echo esc_html__('Educational','caacg'); ?></option>
                  <option value="<?php echo esc_attr('scientific'); ?>"><?php echo esc_html__('Scientific','caacg'); ?></option>
                  <option value="<?php echo esc_attr('expository'); ?>"><?php echo esc_html__('Expository','caacg'); ?></option>
                  <option value="<?php echo esc_attr('descriptive'); ?>"><?php echo esc_html__('Descriptive','caacg'); ?></option>
                  <option value="<?php echo esc_attr('analytical'); ?>"><?php echo esc_html__('Analytical','caacg'); ?></option>
                  <option value="<?php echo esc_attr('comparative'); ?>"><?php echo esc_html__('Comparative','caacg'); ?></option>
                  <option value="<?php echo esc_attr('argumentative'); ?>"><?php echo esc_html__('Argumentative','caacg'); ?></option>
                  <option value="<?php echo esc_attr('instructional'); ?>"><?php echo esc_html__('Instructional','caacg'); ?></option>
                  <option value="<?php echo esc_attr('editorial'); ?>"><?php echo esc_html__('Editorial','caacg'); ?></option>
                  <option value="<?php echo esc_attr('review'); ?>"><?php echo esc_html__('Review','caacg'); ?></option>
                  <option value="<?php echo esc_attr('personal'); ?>"><?php echo esc_html__('Personal','caacg'); ?></option>
                  <option value="<?php echo esc_attr('reflective'); ?>"><?php echo esc_html__('Reflective','caacg'); ?></option>
               </select>

               </td>
         </tr>
         <tr valign="top">
               <th scope="row"><?php echo esc_html(__('Writing Tone','caacg')) ?></th>
               <td>
               <select id="cicg-writing-tone" name="cicg_writing_tone">
                  <option value="<?php echo esc_attr('formal'); ?>"><?php echo esc_html__('Formal','caacg'); ?></option>
                  <option value="<?php echo esc_attr('informal'); ?>"><?php echo esc_html__('Informal','caacg'); ?></option>
                  <option value="<?php echo esc_attr('humorous'); ?>"><?php echo esc_html__('Humorous','caacg'); ?></option>
                  <option value="<?php echo esc_attr('persuasive'); ?>"><?php echo esc_html__('Persuasive','caacg'); ?></option>
                  <option value="<?php echo esc_attr('descriptive'); ?>"><?php echo esc_html__('Descriptive','caacg'); ?></option>
                  <option value="<?php echo esc_attr('instructional'); ?>"><?php echo esc_html__('Instructional','caacg'); ?></option>
                  <option value="<?php echo esc_attr('empathetic'); ?>"><?php echo esc_html__('Empathetic','caacg'); ?></option>
                  <option value="<?php echo esc_attr('critical'); ?>"><?php echo esc_html__('Critical','caacg'); ?></option>
                  <option value="<?php echo esc_attr('optimistic'); ?>"><?php echo esc_html__('Optimistic','caacg'); ?></option>
                  <option value="<?php echo esc_attr('educational'); ?>"><?php echo esc_html__('Educational','caacg'); ?></option>
               </select>
               </td>
         </tr>
         <tr valign="top">
               <th scope="row"><?php echo esc_html(__('SEO Optimize','caacg')) ?></th>
               <td>
                  <label class="switch">
                     <input type="checkbox" class="switch-input" checked>
                     <span class="switch-label" data-on="On" data-off="Off"></span>
                     <span class="switch-handle"></span>
                  </label>
               </td>
         </tr>
         <tr valign="top">
               <th scope="row"><?php echo esc_html(__('Generate Tags','caacg')) ?></th>
               <td>
                  <label class="switch">
                     <input type="checkbox" class="switch-input" checked>
                     <span class="switch-label" data-on="On" data-off="Off"></span>
                     <span class="switch-handle"></span>
                  </label>
               </td>
         </tr>
   
         <tr valign="top">
               <th scope="row"><?php echo esc_html(__('Generate FAQ','caacg')) ?></th>
               <td>
                  <label class="switch faq">
                     <input type="checkbox" class="switch-input" checked>
                     <span class="switch-label" data-on="On" data-off="Off"></span>
                     <span class="switch-handle"></span>
                  </label>
               </td>
         </tr>
         <tr valign="top">
               <th scope="row"><?php echo esc_html(__('Generate Conclusion','caacg')) ?></th>
               <td>
                  <label class="switch conc">
                     <input type="checkbox" class="switch-input" checked>
                     <span class="switch-label" data-on="On" data-off="Off"></span>
                     <span class="switch-handle"></span>
                  </label>
               </td>
         </tr>

         <tr valign="top">
               <th scope="row"><?php echo esc_html(__('Add youtube video','caacg')) ?></th>
               <td>
                  <label class="switch youtube" id="include-youtube-videos">
                     <input type="checkbox" class="switch-input" id="maddyoutubevideo" checked>
                     <span class="switch-label" data-on="On" data-off="Off"></span>
                     <span class="switch-handle"></span>
                  </label>
               </td>
         </tr>
         <tr valign="top" id="youtube-videos-section" style="display: none;">
               <th scope="row"><p><?php echo esc_html(__('Choose where to embed YouTube videos:', 'caacg')); ?></p>
               </th>
               <td>
               <div id="" >
                        <label>
                           <input type="checkbox" name="youtube-video-top" value="1">
                           <?php echo esc_html(__('Top of Page', 'caacg')); ?>
                        </label>
                        <label>
                           <input type="checkbox" name="youtube-video-middle" value="1">
                           <?php echo esc_html(__('Middle of Page', 'caacg')); ?>
                        </label>
                        <label>
                           <input type="checkbox" name="youtube-video-end" value="1">
                           <?php echo esc_html(__('Right Before End of Page', 'caacg')); ?>
                        </label>
                 </div>
               </td>
         </tr>      
         
         <tr valign="top" id="youtube-videos-list" style="display: none;">
               <th scope="row"><p><?php echo esc_html(__('Select video below:', 'caacg')); ?></p>
               </th>
               <td>
               <div id="video-list" class="video-grid"></div>
               </td>
         </tr>          

   </table>
    <div class="generate-text-button">
       

      <input id="cicg_generate_api_content" class="cicg_generate-api-content" type="button" value="<?php echo esc_html(__('Generate Text','caacg')) ?>">
      <!-- loader  -->
      <p class="loading"><?php echo esc_html__('Content Generating Please Wait', 'caacg'); ?></p>
      <p class="failed-api"><?php echo esc_html__('Please Set Api Key: ', 'caacg'); ?><a href="<?php echo esc_url(home_url().'/wp-admin/admin.php?page=api-post-settings'); ?>"><?php echo esc_html__('Click Here', 'caacg'); ?></a></p>
      <p class="generate-success"><?php echo esc_html__('Generated Successfully', 'caacg'); ?></p>
      <p class="form-error"><?php echo esc_html__('Please Fill Up The Title Or Description.', 'caacg'); ?></p>
      <p class="response-error"><?php echo esc_html__('Server Down Please Try Again.', 'caacg'); ?></p>
   </div>
       <div class="cicg_image-generate_section" >
         <div class="search-box">
               <input type="text" name="api-search-img" id="api-search-img" placeholder="Search: Cat"><br>
               <select id="img-size" name="image_size">
                  <option value="<?php echo esc_attr('1024x1024'); ?>"><?php echo esc_html__('1024x1024','caacg'); ?></option>
                  <option value="<?php echo esc_attr('512x512'); ?>"><?php echo esc_html__('512x512','caacg'); ?></option>
                  <option value="<?php echo esc_attr('256x256'); ?>"><?php echo esc_html__('256x256','caacg'); ?></option>
               </select>
            </div>
         <input type="button" id="cicg_openapi-image-generator" class="cicg_openapi-image-generator" value="<?php echo esc_html(__('Generate Image','caacg')) ?>"></input>
         <p class="image-form-error"><?php echo esc_html__('Please Fill Up Search Box.', 'caacg'); ?></p>
         <div class="image-content">
            <div id="cicg_openapi-image-grid"> </div>
            <div class="container" id="hide-loader-img">
                  <div class="load-container">
                     <div class="linespinner"></div>
                  </div>
            </div> 
         </div>
         <div class="upload-success"><p><?php echo esc_html__('Image Uploaded Successfully', 'caacg'); ?></p></div> 
            </div>    
       </div>
   </div>
   <!--<div class="cicg-social-share-metabox">
      <p><strong><?php //echo esc_html(__('Share on:','caacg')) ?></strong></p>
      <button class="cicg-social-share-metabox-btn" data-social="facebook"><img src="<?php // echo esc_url( plugin_dir_url( dirname( __FILE__ ) ) . 'img/cicg-facebook.png' ); ?>" alt="facebook"></button>
      <button class="cicg-social-share-metabox-btn" data-social="twitter"><img src="<?php //echo esc_url( plugin_dir_url( dirname( __FILE__ ) ) . 'img/cicg-twitter.png' ); ?>" alt="twitter"></button>
      <button class="cicg-social-share-metabox-btn" data-social="pinterest"><img src="<?php //echo esc_url( plugin_dir_url( dirname( __FILE__ ) ) . 'img/cicg-pinterest.png' ); ?>" alt="pinterest"></button>
      <button class="cicg-social-share-metabox-btn" data-social="linkedin"><img src="<?php // echo esc_url( plugin_dir_url( dirname( __FILE__ ) ) . 'img/cicg-linkedin.png' ); ?>" alt="linkedin"></button>
      <input type="hidden" name="cicg_social_share" value="<?php // echo esc_attr( $post_permalink ); ?>">
   </div>-->
<div id="keyword-research-popup" style="display:none; position:fixed; top:50%; left:50%; transform:translate(-50%, -50%); background-color:#fff; padding:20px; box-shadow:0px 0px 10px rgba(0,0,0,0.5); z-index:9999;">
    <span id="close-popup" style="cursor:pointer; float:right;font-size:20px;">&times;</span>
    <h2>Keyword Research</h2>
    <input type="text" id="keyword-input" placeholder="Enter keyword" style="width:100%; padding:10px; margin-bottom:10px;">
        <div id="empty-keyword-message" style="color: red; display: none;">Keyword cannot be empty</div>
    <div id="loading-icon" style="font-weight:bold;display: none;">Loading...</div>

    <button id="search-keywords" style="padding:10px 20px;">Search</button>
        <div id="suggestions" class="suggestions"></div>
</div>
<script type="text/javascript">
        document.addEventListener('DOMContentLoaded', function() {
            var keywordLink = document.getElementById('keyword-research-link');
            var popup = document.getElementById('keyword-research-popup');
            var closePopup = document.getElementById('close-popup');
            var searchButton = document.getElementById('search-keywords');
            var keywordInput = document.getElementById('keyword-input');
            var suggestions = document.getElementById('suggestions');
            var titleInput = document.getElementById('cicg-api-post-title');
    var emptyKeywordMessage = document.getElementById('empty-keyword-message');
    var loadingIcon = document.getElementById('loading-icon');

            keywordLink.addEventListener('click', function(event) {
                event.preventDefault();
                popup.style.display = 'block';
            });

            closePopup.addEventListener('click', function() {
                popup.style.display = 'none';
            });

            searchButton.addEventListener('click', function() {
                var keyword = keywordInput.value;
                if (keyword) {
                    emptyKeywordMessage.style.display = 'none';
                    fetchKeywords(keyword);
                } else {
                 emptyKeywordMessage.style.display = 'block';
                }
            });
  
    
      function fetchKeywords(keyword) {
                  loadingIcon.style.display = 'block';
        fetch('<?php echo admin_url('admin-ajax.php'); ?>?action=get_keywords&keyword=' + encodeURIComponent(keyword))
            .then(response => response.json())
            .then(data => {
            loadingIcon.style.display = 'none';
            if (data.success && Array.isArray(data.data.keywords)) {
                    showSuggestions(data.data.keywords);
                } else {
                    
                    
                    console.error('Invalid response or no keywords found:', data);
                    suggestions.innerHTML = '';
                }
            })
            .catch(error => {
                loadingIcon.style.display = 'none';
                console.error('Error fetching keywords:', error);
                suggestions.innerHTML = '';
            });
    }

            
         


          function insertKeyword(keyword) {
                titleInput.value = keyword;
                popup.style.display = 'none';
            }
            
             function showSuggestions(keywords) {
                suggestions.innerHTML = '';
                keywords.forEach(function(keyword) {
                    var item = document.createElement('div');
                    item.classList.add('suggestion-item');
                    item.textContent = keyword;
                    item.addEventListener('click', function() {
                        insertKeyword(keyword);
                    });
                    suggestions.appendChild(item);
                });
                suggestions.style.display = 'block';
            }    

            keywordInput.addEventListener('input', function() {
                var value = keywordInput.value.toLowerCase();
                var items = suggestions.querySelectorAll('.suggestion-item');
                items.forEach(function(item) {
                    if (item.textContent.toLowerCase().includes(value)) {
                        item.style.display = 'block';
                    } else {
                        item.style.display = 'none';
                    }
                });
                suggestions.style.display = items.length ? 'block' : 'none';
            });
        });
        </script>
<style>
#keyword-research-popup {
    position: fixed;
    top: 50%;
    left: 50%;
    transform: translate(-50%, -50%);
    width: 400px;
    padding: 20px;
    background: #000;
    box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
    z-index: 1000;
    
}

#keyword-research-popup #popup-content {
    text-align: center;
}

#keyword-research-popup h3 {
    margin-top: 0;
    color:#fff;
}

#keyword-research-popup input[type="text"] {
            width: calc(100% - 22px);
            padding: 10px;
            margin-bottom: 10px;
            background: #333;
            border: 1px solid #444;
            color: #fff;

}

        #keyword-research-popup button {
            padding: 10px 20px;
            margin-top: 10px;
            cursor: pointer;
            background: #444;
            border: 1px solid #555;
            color: #fff;
        }

        #keyword-results {
            margin-top: 20px;
            max-height: 200px;
            overflow-y: auto;
        }

        #keyword-results p {
            margin: 0;
            padding: 10px;
            background: #444;
            border: 1px solid #555;
            border-radius: 4px;
        }

        #keyword-results p:hover {
            background: #555;
        }
                .suggestions {
            border: 1px solid #ccc;
            max-height: 150px;
            overflow-y: auto;
            display: none;
        }
        .suggestion-item {
            padding: 10px;
            cursor: pointer;
        }
        .suggestion-item:hover {
            background-color: #f0f0f0;
        }
        .cicg_section-content-api input#cicg-api-post-title{
            width:40%;
        }
        @media (max-width: 767px) {
            .cicg_section-content-api input#cicg-api-post-title {
                width: 100%;
            }
        }


    
</style> 
    
   <?php
   
}
/**
 * Display metabox field for woocommerce product
 */
function mych_chatgpt_render_metabox_custom_field_woocommerce( $post ) {
   // Get the current post object
   global $post;
   // Get the full permalink of the current post
   $post_permalink = get_permalink( $post->ID);
   ?>
   
   <div class="cicg_section-content-api" id="cicg_section-content-api">
   
      <table class="form-table ">
         <tr valign="top">
            <th scope="row"><?php echo esc_html(__('Title','caacg')); ?></th>
            <td>
                  <input type="text" name="cicg-api-post-title" id="cicg-api-post-title" placeholder="<?php echo esc_html(__('Enter a product title, e.g. CBD oil','caacg')); ?>">
                  <label class="switch cicg-product-title">
                     <input type="checkbox" class="switch-input" id="switch-product-title" checked>
                     <span class="switch-label" data-on="On" data-off="Off"></span>
                     <span class="switch-handle"></span>
                  </label>
            </td>
            
         </tr>
         <tr valign="top">
            <th scope="row"><?php echo esc_html(__('Description','caacg')); ?></th>
            <td>
                  <textarea name="cicg-api-post-description" id="cicg-api-post-description" cols="0" rows="3" placeholder="<?php echo esc_html(__('Enter a product description, e.g. Write a description for CBD oil','caacg')); ?>"></textarea>
            </td>
         </tr>
         <tr valign="top">
            <th scope="row"><?php echo esc_html(__('Content length','caacg')); ?></th>
            <td>
                  <input type="number" name="cicg_content_length" id="cicg-content-length" value="300" />
            </td>
         </tr>
         <tr valign="top">
               <th scope="row"><?php echo esc_html(__('Language','caacg')); ?></th>
               <td>
                  <label>
                  <select id="cicg-select-lenguage">
                  <option value="<?php echo esc_attr('en'); ?>"><?php echo esc_html__('English','caacg'); ?></option>
                  <option value="<?php echo esc_attr('fr'); ?>"><?php echo esc_html__('French','caacg'); ?></option>
                  <option value="<?php echo esc_attr('de'); ?>"><?php echo esc_html__('German','caacg'); ?></option>
                  <option value="<?php echo esc_attr('es'); ?>"><?php echo esc_html__('Spanish','caacg'); ?></option>
                  <option value="<?php echo esc_attr('it'); ?>"><?php echo esc_html__('Italian','caacg'); ?></option>
                  <option value="<?php echo esc_attr('pt'); ?>"><?php echo esc_html__('Portuguese','caacg'); ?></option>
                  <option value="<?php echo esc_attr('nl'); ?>"><?php echo esc_html__('Dutch','caacg'); ?></option>
                  <option value="<?php echo esc_attr('ru'); ?>"><?php echo esc_html__('Russian','caacg'); ?></option>
                  <option value="<?php echo esc_attr('ar'); ?>"><?php echo esc_html__('Arabic','caacg'); ?></option>
                  <option value="<?php echo esc_attr('zh'); ?>"><?php echo esc_html__('Chinese (Simplified)'); ?></option>
                  <option value="<?php echo esc_attr('zh-TW'); ?>"><?php echo esc_html__('Chinese (Traditional)','caacg'); ?></option>
                  <option value="<?php echo esc_attr('ja'); ?>"><?php echo esc_html__('Japanese','caacg'); ?></option>
                  <option value="<?php echo esc_attr('ko'); ?>"><?php echo esc_html__('Korean','caacg'); ?></option>
                  <option value="<?php echo esc_attr('hi'); ?>"><?php echo esc_html__('Hindi','caacg'); ?></option>
                  <option value="<?php echo esc_attr('bn'); ?>"><?php echo esc_html__('Bengali','caacg'); ?></option>
                  <option value="<?php echo esc_attr('ur'); ?>"><?php echo esc_html__('Urdu','caacg'); ?></option>
                  <option value="<?php echo esc_attr('fa'); ?>"><?php echo esc_html__('Persian (Farsi)','caacg'); ?></option>
                  <option value="<?php echo esc_attr('tr'); ?>"><?php echo esc_html__('Turkish','caacg'); ?></option>
                  <option value="<?php echo esc_attr('el'); ?>"><?php echo esc_html__('Greek','caacg'); ?></option>
                  <option value="<?php echo esc_attr('pl'); ?>"><?php echo esc_html__('Polish','caacg'); ?></option>
                  <option value="<?php echo esc_attr('cs'); ?>"><?php echo esc_html__('Czech','caacg'); ?></option>
                  <option value="<?php echo esc_attr('hu'); ?>"><?php echo esc_html__('Hungarian','caacg'); ?></option>
                  <option value="<?php echo esc_attr('fi'); ?>"><?php echo esc_html__('Finnish','caacg'); ?></option>
                  <option value="<?php echo esc_attr('sv'); ?>"><?php echo esc_html__('Swedish','caacg'); ?></option>
                  <option value="<?php echo esc_attr('no'); ?>"><?php echo esc_html__('Norwegian','caacg'); ?></option>
                  <option value="<?php echo esc_attr('da'); ?>"><?php echo esc_html__('Danish','caacg'); ?></option>
                  <option value="<?php echo esc_attr('is'); ?>"><?php echo esc_html__('Icelandic','caacg'); ?></option>
                  <option value="<?php echo esc_attr('ga'); ?>"><?php echo esc_html__('Irish','caacg'); ?></option>
                  <option value="<?php echo esc_attr('eu'); ?>"><?php echo esc_html__('Basque','caacg'); ?></option>
                  <option value="<?php echo esc_attr('et'); ?>"><?php echo esc_html__('Estonian','caacg'); ?></option>
                  <option value="<?php echo esc_attr('lv'); ?>"><?php echo esc_html__('Latvian','caacg'); ?></option>
                  <option value="<?php echo esc_attr('lt'); ?>"><?php echo esc_html__('Lithuanian','caacg'); ?></option>
                  <option value="<?php echo esc_attr('ro'); ?>"><?php echo esc_html__('Romanian','caacg'); ?></option>
                  <option value="<?php echo esc_attr('sr'); ?>"><?php echo esc_html__('Serbian','caacg'); ?></option>
                  <option value="<?php echo esc_attr('sk'); ?>"><?php echo esc_html__('Slovak','caacg'); ?></option>
                  <option value="<?php echo esc_attr('sl'); ?>"><?php echo esc_html__('Slovenian','caacg'); ?></option>
                  <option value="<?php echo esc_attr('uk'); ?>"><?php echo esc_html__('Ukrainian','caacg'); ?></option>
                  <option value="<?php echo esc_attr('hr'); ?>"><?php echo esc_html__('Croatian','caacg'); ?></option>
                  <option value="<?php echo esc_attr('bg'); ?>"><?php echo esc_html__('Bulgarian','caacg'); ?></option>

                  </select>
                  </label>
               </td>
         </tr>
         <tr valign="top">
               <th scope="row"><?php echo esc_html(__('Writing Style','caacg')) ?></th>
               <td>
               <select name="cicg_writing_style" id="cicg-writing-style">
                  <option value="<?php echo esc_attr('formal'); ?>"><?php echo esc_html__('Formal','caacg'); ?></option>
                  <option value="<?php echo esc_attr('informal'); ?>"><?php echo esc_html__('Informal','caacg'); ?></option>
                  <option value="<?php echo esc_attr('technical'); ?>"><?php echo esc_html__('Technical','caacg'); ?></option>
                  <option value="<?php echo esc_attr('creative'); ?>"><?php echo esc_html__('Creative','caacg'); ?></option>
                  <option value="<?php echo esc_attr('professional'); ?>"><?php echo esc_html__('Professional','caacg'); ?></option>
                  <option value="<?php echo esc_attr('persuasive'); ?>"><?php echo esc_html__('Persuasive','caacg'); ?></option>
                  <option value="<?php echo esc_attr('narrative'); ?>"><?php echo esc_html__('Narrative','caacg'); ?></option>
                  <option value="<?php echo esc_attr('humorous'); ?>"><?php echo esc_html__('Humorous','caacg'); ?></option>
                  <option value="<?php echo esc_attr('educational'); ?>"><?php echo esc_html__('Educational','caacg'); ?></option>
                  <option value="<?php echo esc_attr('scientific'); ?>"><?php echo esc_html__('Scientific','caacg'); ?></option>
                  <option value="<?php echo esc_attr('expository'); ?>"><?php echo esc_html__('Expository','caacg'); ?></option>
                  <option value="<?php echo esc_attr('descriptive'); ?>"><?php echo esc_html__('Descriptive','caacg'); ?></option>
                  <option value="<?php echo esc_attr('analytical'); ?>"><?php echo esc_html__('Analytical','caacg'); ?></option>
                  <option value="<?php echo esc_attr('comparative'); ?>"><?php echo esc_html__('Comparative','caacg'); ?></option>
                  <option value="<?php echo esc_attr('argumentative'); ?>"><?php echo esc_html__('Argumentative','caacg'); ?></option>
                  <option value="<?php echo esc_attr('instructional'); ?>"><?php echo esc_html__('Instructional','caacg'); ?></option>
                  <option value="<?php echo esc_attr('editorial'); ?>"><?php echo esc_html__('Editorial','caacg'); ?></option>
                  <option value="<?php echo esc_attr('review'); ?>"><?php echo esc_html__('Review','caacg'); ?></option>
                  <option value="<?php echo esc_attr('personal'); ?>"><?php echo esc_html__('Personal','caacg'); ?></option>
                  <option value="<?php echo esc_attr('reflective'); ?>"><?php echo esc_html__('Reflective','caacg'); ?></option>
               </select>

               </td>
         </tr>
         <tr valign="top">
               <th scope="row"><?php echo esc_html(__('Writing Tone','caacg')) ?></th>
               <td>
               <select id="cicg-writing-tone" name="cicg_writing_tone">
                  <option value="<?php echo esc_attr('formal'); ?>"><?php echo esc_html__('Formal','caacg'); ?></option>
                  <option value="<?php echo esc_attr('informal'); ?>"><?php echo esc_html__('Informal','caacg'); ?></option>
                  <option value="<?php echo esc_attr('humorous'); ?>"><?php echo esc_html__('Humorous','caacg'); ?></option>
                  <option value="<?php echo esc_attr('persuasive'); ?>"><?php echo esc_html__('Persuasive','caacg'); ?></option>
                  <option value="<?php echo esc_attr('descriptive'); ?>"><?php echo esc_html__('Descriptive','caacg'); ?></option>
                  <option value="<?php echo esc_attr('instructional'); ?>"><?php echo esc_html__('Instructional','caacg'); ?></option>
                  <option value="<?php echo esc_attr('empathetic'); ?>"><?php echo esc_html__('Empathetic','caacg'); ?></option>
                  <option value="<?php echo esc_attr('critical'); ?>"><?php echo esc_html__('Critical','caacg'); ?></option>
                  <option value="<?php echo esc_attr('optimistic'); ?>"><?php echo esc_html__('Optimistic','caacg'); ?></option>
                  <option value="<?php echo esc_attr('educational'); ?>"><?php echo esc_html__('Educational','caacg'); ?></option>
               </select>
               </td>
         </tr>
         <tr valign="top">
               <th scope="row"><?php echo esc_html(__('SEO Optimize','caacg')) ?></th>
               <td>
                  <label class="switch">
                     <input type="checkbox" class="switch-input" checked>
                     <span class="switch-label" data-on="On" data-off="Off"></span>
                     <span class="switch-handle"></span>
                  </label>
               </td>
         </tr>
         <tr valign="top">
               <th scope="row"><?php echo esc_html(__('Generate Tags','caacg')) ?></th>
               <td>
                  <label class="switch">
                     <input type="checkbox" class="switch-input" checked>
                     <span class="switch-label" data-on="On" data-off="Off"></span>
                     <span class="switch-handle"></span>
                  </label>
               </td>
         </tr>
   
   </table>
    <div class="generate-text-button">
      <input id="cicg_generate_product_content" class="cicg_generate-api-content" type="button" value="<?php echo esc_html(__('Generate Text','caacg')) ?>">
      <!-- loader  -->
      <p class="loading"><?php echo esc_html__('Content Generating Please Wait', 'caacg'); ?></p>
      <p class="failed-api"><?php echo esc_html__('Please Set Api Key: ', 'caacg'); ?><a href="<?php echo esc_url(home_url().'/wp-admin/admin.php?page=api-post-settings'); ?>"><?php echo esc_html__('Click Here', 'caacg'); ?></a></p>
      <p class="generate-success"><?php echo esc_html__('Generated Successfully', 'caacg'); ?></p>
      <p class="form-error"><?php echo esc_html__('Please Fill Up The Title Or Description.', 'caacg'); ?></p>
      <p class="response-error"><?php echo esc_html__('Server Down Please Try Again.', 'caacg'); ?></p>
   </div>
       <div class="cicg_image-generate_section" >
         <div class="search-box">
               <input type="text" name="api-search-img" id="api-search-img" placeholder="Search: Cat"><br>
               <select id="img-size" name="image_size">
                  <option value="<?php echo esc_attr('1024x1024'); ?>"><?php echo esc_html__('1024x1024','caacg'); ?></option>
                  <option value="<?php echo esc_attr('512x512'); ?>"><?php echo esc_html__('512x512','caacg'); ?></option>
                  <option value="<?php echo esc_attr('256x256'); ?>"><?php echo esc_html__('256x256','caacg'); ?></option>
               </select>
            </div>
         <input type="button" id="cicg_openapi-image-generator" class="cicg_openapi-image-generator" value="<?php echo esc_html(__('Generate Image','caacg')) ?>"></input>
         <p class="image-form-error"><?php echo esc_html__('Please Fill Up Search Box.', 'caacg'); ?></p>
         <div class="image-content">
            <div id="cicg_openapi-image-grid"> </div>
            <div class="container" id="hide-loader-img">
                  <div class="load-container">
                     <div class="linespinner"></div>
                  </div>
            </div> 
         </div>
         <div class="upload-success"><p><?php echo esc_html__('Image Uploaded Successfully', 'caacg'); ?></p></div> 
            </div>    
       </div>
   </div>
   <div class="cicg-social-share-metabox">
      <p><strong><?php echo esc_html(__('Share on:','caacg')) ?></strong></p>
      <button class="cicg-social-share-metabox-btn" data-social="facebook"><img src="<?php echo esc_url( plugin_dir_url( dirname( __FILE__ ) ) . 'img/cicg-facebook.png' ); ?>" alt="facebook"></button>
      <button class="cicg-social-share-metabox-btn" data-social="twitter"><img src="<?php echo esc_url( plugin_dir_url( dirname( __FILE__ ) ) . 'img/cicg-twitter.png' ); ?>" alt="twitter"></button>
      <button class="cicg-social-share-metabox-btn" data-social="pinterest"><img src="<?php echo esc_url( plugin_dir_url( dirname( __FILE__ ) ) . 'img/cicg-pinterest.png' ); ?>" alt="pinterest"></button>
      <button class="cicg-social-share-metabox-btn" data-social="linkedin"><img src="<?php echo esc_url( plugin_dir_url( dirname( __FILE__ ) ) . 'img/cicg-linkedin.png' ); ?>" alt="linkedin"></button>
      <input type="hidden" name="cicg_social_share" value="<?php echo esc_attr( $post_permalink ); ?>">
   </div>

    
   <?php
   
}