<?php
/**
 * Display post schedule
 */
function mych_post_schedule_display( ) {
      
   ?>
   <div class="">
      <h3><?php echo esc_html( __('Post Schedule', 'caacg') ); ?></h3>
   </div>
   <div class="cicg_chatgpt-schedule-content">
      <div class="success-message">
         <div id="countdown-timer"></div>
      </div>
      <div class="upcoming-post">
         <h3><?php echo esc_html( __('Upcoming post','caacg') )  ?></h3> 
         <div class="table-responsive">
            <table class="table table-primary">
            <thead>
               <tr>
                  <th scope="col" style="width:70%"><?php echo esc_html( __('Title','caacg')) ?></th>
                  <th scope="col"><?php echo esc_html(__('Publish Date','caacg')  )?></th>
                  <th scope="col"><?php echo esc_html(__('Status','caacg') ) ?></th>
               </tr>
            </thead>
               <tbody>
                  <?php 
                  $args = array(
                     'post_type' => 'post',
                     'post_status' => 'future',
                     'posts_per_page' => -1 // Retrieve all future posts
               );
               
               $query = new WP_Query( $args );
               
               if ( $query->have_posts() ) {
                  while ( $query->have_posts() ) {
                     $query->the_post();
                        echo '<tr class="conten-row">
                        <td scope="row" class="title">'.get_the_title(). '</td>
                        <td class="date">'.get_the_date( 'Y-m-d H:i:s', get_the_ID() ).'</td>
                        <td class="status">Future</td>
                     </tr>';
                        
                     }
               
                     wp_reset_postdata();
               }else{
                     echo '<div class="post-content">
                     <p>No Post Found</p>
                  </div>';
               } 
                  
                  ?>
               
               </tbody>
            </table>
         </div>    
      </div>
   
      <h3 class="create-post"><?php echo esc_html(__('Create Post','caacg')) ?></h3>
      <form method="post" action ="" class="repeater" id="cicg_schedule_settings">
      <div id="form_group" data-repeater-list="status_group">
         <div data-repeater-item class="repeater-item">
         <input type="hidden" name="id" id="cat-id"/>
         <div class="post-title">
               <label for="post-title"><?php echo esc_html( __('Title','caacg') ) ?></label>
               <input type="text" name="post_title" placeholder="Enter a Topic, eg: CBD Oil" />
         </div>
         <div class="post-description">
               <label for="post-description"><?php echo esc_html(__('Description','caacg')) ?></label>
               <input type="text" name="post_description" placeholder="Description,eg: Write a description about CBD Oil" />
         </div>
         <div>
            <label for="post-description"><?php echo esc_html( __('Date and time','caacg') ) ?></label>
            <input type="datetime-local" class="post-title" name="post_date" required><br>
         </div>
         
         <input data-repeater-delete type="button" value="<?php echo esc_html( __('Delete','caacg') ) ?>"/>
         </div>
      </div>
      <input class="add-button" data-repeater-create type="button" value="<?php echo esc_html( __('+ Add','caacg') ) ?>"/>
      <?php submit_button(); ?>
      <p class="schedule-form-error"><?php echo esc_html(__('Please Fill Up The Title and Description.','caacg')) ?></p>
      </form>
   </div>
    
   <?php
   
}
