<style>
.pdf_link
{
	width: 100%;
    border-radius: 5px;
	height: 40px;
    font-size: 16px;
}
.overlay {
  position: fixed;
  top: 0;
  bottom: 0;
  left: 0;
  right: 0;
  background: rgba(0, 0, 0, 0.7);
  transition: opacity 500ms;
  visibility: hidden;
  opacity: 0;
}
.overlay:target {
  visibility: visible;
  opacity: 1;
}

.popup {
  margin: 70px auto;
  padding: 20px;
  background: #fff;
  border-radius: 5px;
  width: 50%;
  position: relative;
  /* transition: all 5s ease-in-out; */
}

.popup h2 {
  margin-top: 0;
  color: #333;
  font-family: Tahoma, Arial, sans-serif;
  line-height:30px;
}
.popup .close {
  position: absolute;
  top: 20px;
  right: 30px;
  transition: all 200ms;
  font-size: 30px;
  font-weight: bold;
  text-decoration: none;
  color: #333;
}
.popup .close:hover {
  color: #06D85F;
}
.popup .content {
  max-height: 30%;
  overflow: auto;
}

@media screen and (max-width: 700px){
  .popup{
    width: 70%;
  }
}

.tooltips {
  position: relative;
  display: inline-block;
}

.tooltips .tooltiptext {
  visibility: hidden;
  width: 140px;
  background-color: #555;
  color: #fff;
  text-align: center;
  border-radius: 6px;
  padding: 5px;
  position: absolute;
  z-index: 1;
  bottom: 150%;
  left: 50%;
  margin-left: -75px;
  opacity: 0;
  transition: opacity 0.3s;
}

.tooltips .tooltiptext::after {
  content: "";
  position: absolute;
  top: 100%;
  left: 50%;
  margin-left: -5px;
  border-width: 5px;
  border-style: solid;
  border-color: #555 transparent transparent transparent;
}

.tooltips:hover .tooltiptext {
  visibility: visible;
  opacity: 1;
}
#article_message, #article_messages
{
	width: 100%;
    height: 370px;
    -webkit-box-sizing: border-box;
    -moz-box-sizing: border-box;
    box-sizing: border-box;
    color: #666666;
    border: 0 none;
    border-radius: 4px;
    background: url(../wp-content/plugins/MyContentCreatorPro-Free/includes/assets/images/note.png) repeat;
    font: normal 14px verdana;
    line-height: 25px;
    padding: 2px 10px;
    border: solid 1px #ddd;
    transition: all 0.1s ease-in-out 0s;
    animation-delay: 250ms;
    animation-name: slideInRight;
    animation-duration: 1s;
    animation-fill-mode: both;		
}
.btn_spin, .btn_spin_copy , .btn_spin_post , .btn_spin_pdf, .link_try, .btn_pdf_download
{
	background: #5ec79e !important;
    border-radius: 7px !important;
    color: #fff !important;
    margin-top: 10px !important;
    padding: 15px !important;
    text-decoration: none !important;
	font-size: 18px !important;
    border: 1px solid !important;
	display:block;
}
.btn_spin:hover, .btn_spin_copy:hover , .btn_spin_post:hover , .btn_spin_pdf:hover, .link_try:hover, .btn_pdf_download:hover
{
	background: #887dc2 !important;
}
.pagination {
   clear:both;
   position:relative;
   font-size:11px; /* Pagination text size */
   line-height:13px;
   float:right; /* Pagination float direction */
}
.pagination span, .pagination a {
   display:block;
   float:left;
   margin: 2px 2px 2px 0;
   padding:6px 9px 5px 9px;
   text-decoration:none;
   width:auto;
   color:#fff; /* Pagination text color */
   background: #555; /* Pagination non-active background color */
   -webkit-transition: background .15s ease-in-out;
   -moz-transition: background .15s ease-in-out;
   -ms-transition: background .15s ease-in-out;
   -o-transition: background .15s ease-in-out;
   transition: background .15s ease-in-out;
}
.pagination a:hover{
   color:#fff;
   background: #6AAC70; /* Pagination background on hover */
}
.pagination .current{
   padding:6px 9px 5px 9px;
   background: #6AAC70; /* Current page background */
   color:#fff;
}
.btn_spin_pdf, .btn_pdf_download
{
	background: #5ec79e !important;
    border-radius: 7px !important;
    color: #fff !important;
    margin-top: 10px !important;
    padding: 10px !important;
    text-decoration: none !important;
	font-size: 16px !important;
    border: 1px solid !important;
	display:block;
}
.btn_spin_pdf:hover, .btn_pdf_download:hover
{
	background: #887dc2 !important;
}
</style>

<div class="content_hero_container" style="overflow:hidden;">
<div class="container">
<div class="row">
	<div class="notice" style="display:none;">
		<p class="ch_msg"></p>
	</div>	
    <div class="col-md-8">
		<h2 style="">API Settings</h2>
	    <?php $ezinearticle_api = get_option('wpch_ezinearticle_api',true); ?>
        <div id="spin_div">
			<form id="form-spin ">
				<div class="row">
					<div class="col-md-2">
						<label for="ezinearticle_api">Ezine Article Api</label>
					</div>
					<div class="col-md-6">
						<input type="text" class="form-control" id="ezinearticle_api" name="ezinearticle_api" value="<?php echo $ezinearticle_api; ?>" placeholder="enter ezinearticle api.." required>
					</div>
				</div>
				<div class="row">
				    <div class="col-md-2">
						<label for="save_api"></label>
					</div>
					<div class="col-md-9">
						<input type="button" class="btn btn-primary" id="save_api" value="Save" />
					</div>
					
				</div>	
			</form>	
		</div>	
	</div>
</div>
</div>

<script>
jQuery(document).ready(function($){
	$('#save_api').click(function(){
        $(".notice").hide();
		$(".notice").removeClass('updated');
		$(".notice").removeClass('error');		
		var ajaxurl = "<?php echo admin_url('admin-ajax.php'); ?>";
		var ezinearticle_api = $("#ezinearticle_api").val();

		var api_data_search = {
			action: 'save_api_settings_result',
			ezinearticle_api : ezinearticle_api,
		};
		$.post(ajaxurl, api_data_search, function(ch_response){
			if(ch_response=='success'){
				$(".notice").addClass('updated');
				$(".notice").show();
				$(".ch_msg").html('Api successfully updated');	
			}else{
				$(".notice").addClass('error');
				$(".notice").show();
				$(".ch_msg").html(ch_response);				
			}
		});
	});
});
</script>