<style>
.pdf_link
{
	width: 100%;
    border-radius: 5px;
	height: 40px;
    font-size: 16px;
}
.overlay {
  position: fixed;
  top: 0;
  bottom: 0;
  left: 0;
  right: 0;
  background: rgba(0, 0, 0, 0.7);
  transition: opacity 500ms;
  visibility: hidden;
  opacity: 0;
}
.overlay:target {
  visibility: visible;
  opacity: 1;
}

.popup {
  margin: 70px auto;
  padding: 20px;
  background: #fff;
  border-radius: 5px;
  width: 50%;
  position: relative;
  /* transition: all 5s ease-in-out; */
}

.popup h2 {
  margin-top: 0;
  color: #333;
  font-family: Tahoma, Arial, sans-serif;
  line-height:30px;
}
.popup .close {
  position: absolute;
  top: 20px;
  right: 30px;
  transition: all 200ms;
  font-size: 30px;
  font-weight: bold;
  text-decoration: none;
  color: #333;
}
.popup .close:hover {
  color: #06D85F;
}
.popup .content {
  max-height: 30%;
  overflow: auto;
}

@media screen and (max-width: 700px){
  .popup{
    width: 70%;
  }
}

.tooltips {
  position: relative;
  display: inline-block;
}

.tooltips .tooltiptext {
  visibility: hidden;
  width: 140px;
  background-color: #555;
  color: #fff;
  text-align: center;
  border-radius: 6px;
  padding: 5px;
  position: absolute;
  z-index: 1;
  bottom: 150%;
  left: 50%;
  margin-left: -75px;
  opacity: 0;
  transition: opacity 0.3s;
}

.tooltips .tooltiptext::after {
  content: "";
  position: absolute;
  top: 100%;
  left: 50%;
  margin-left: -5px;
  border-width: 5px;
  border-style: solid;
  border-color: #555 transparent transparent transparent;
}

.tooltips:hover .tooltiptext {
  visibility: visible;
  opacity: 1;
}
#article_message, #article_messages
{
	width: 100%;
    height: 370px;
    -webkit-box-sizing: border-box;
    -moz-box-sizing: border-box;
    box-sizing: border-box;
    color: #666666;
    border: 0 none;
    border-radius: 4px;
    background: url(../wp-content/plugins/MyContentCreatorPro-Free/includes/assets/images/note.png) repeat;
    font: normal 14px verdana;
    line-height: 25px;
    padding: 2px 10px;
    border: solid 1px #ddd;
    transition: all 0.1s ease-in-out 0s;
    animation-delay: 250ms;
    animation-name: slideInRight;
    animation-duration: 1s;
    animation-fill-mode: both;		
}
.btn_spin, .btn_spin_copy , .btn_spin_post , .btn_spin_pdf, .link_try, .btn_pdf_download
{
	background: #5ec79e !important;
    border-radius: 7px !important;
    color: #fff !important;
    margin-top: 10px !important;
    padding: 15px !important;
    text-decoration: none !important;
	font-size: 18px !important;
    border: 1px solid !important;
	display:block;
}
.btn_spin:hover, .btn_spin_copy:hover , .btn_spin_post:hover , .btn_spin_pdf:hover, .link_try:hover, .btn_pdf_download:hover
{
	background: #887dc2 !important;
}
.pagination {
   clear:both;
   position:relative;
   font-size:11px; /* Pagination text size */
   line-height:13px;
   float:right; /* Pagination float direction */
}
.pagination span, .pagination a {
   display:block;
   float:left;
   margin: 2px 2px 2px 0;
   padding:6px 9px 5px 9px;
   text-decoration:none;
   width:auto;
   color:#fff; /* Pagination text color */
   background: #555; /* Pagination non-active background color */
   -webkit-transition: background .15s ease-in-out;
   -moz-transition: background .15s ease-in-out;
   -ms-transition: background .15s ease-in-out;
   -o-transition: background .15s ease-in-out;
   transition: background .15s ease-in-out;
}
.pagination a:hover{
   color:#fff;
   background: #6AAC70; /* Pagination background on hover */
}
.pagination .current{
   padding:6px 9px 5px 9px;
   background: #6AAC70; /* Current page background */
   color:#fff;
}
.btn_spin_pdf, .btn_pdf_download
{
	background: #5ec79e !important;
    border-radius: 7px !important;
    color: #fff !important;
    margin-top: 10px !important;
    padding: 10px !important;
    text-decoration: none !important;
	font-size: 15px !important;
    border: 1px solid !important;
	display:block;
	text-align:center;
}
.btn_spin_pdf:hover, .btn_pdf_download:hover
{
	background: #887dc2 !important;
}
.table-striped td{vertical-align:middle !important;}
.content_hero_container .row{margin-bottom:15px;}
</style>


<h1 style="padding-left: 15px;">PDF Generator</h1>

<?php

//global $wp_query, $paged;
//$paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
$paged = (isset($_GET['paged']) && $_GET['paged']!=''?$_GET['paged']:1);
$args = array(
'post_type'=> 'post',
'orderby'    => 'ID',
'post_status' => 'publish',
'order'    => 'DESC',
'posts_per_page' => 20,
'paged' => $paged
);
$result = new WP_Query( $args );?>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
<div class="content_hero_container">
<div class="panel-body table-responsive">
    <table class="table table-striped widefat" style="width:100%;">
      <thead>
        <tr>
          <th style="text-align: inherit;font-weight: 700;">Post Title</th>
     	  <th style="text-align: inherit;font-weight: 700;">View PDF</th>
		  <th style="text-align: inherit;font-weight: 700;">Download PDF</th>
		  <th style="text-align: inherit;font-weight: 700;">PDF Social Share</th>
          <th style="text-align: inherit;font-weight: 700;">Action<h>
        </tr>
      </thead>
      <tbody>
        <?php $a = 0; if ( $result-> have_posts() ) :
        while ( $result->have_posts() ) : $result->the_post(); 
		$pdf_link = get_post_meta(get_the_id(),'wpch_link_pdf',true); 
        ?>
        <tr>
            <td><?php echo get_the_title(); ?></td>
			<?php 
			if(isset($pdf_link) && $pdf_link!=''){
			?>
            <td><a target="_blank" href="<?php echo $pdf_link; ?>" >View PDF</a></td>
			<td><a href="<?php echo $pdf_link; ?>" download >Download PDF</a></td>			
            <td style="vertical-align:middle;">
                <?php 
				//$image = wp_get_attachment_image_src( get_post_thumbnail_id( $result->ID )); 
				$image[0] = WPCH_PLUGIN_URL . 'assets/img/click.png';
				?>
 			    <a target="_blank" href="https://www.slideshare.net/upload"><img style="vertical-align: inherit;" src="<?php echo plugins_url('MyContentCreatorPro/assets/img/slideshare.png'); ?>" width="24" height="24" alt="Slideshare pdf share "/></a>
 			    <a target="_blank" href="https://smallpdf.com/share-document"><img style="vertical-align: inherit;" src="<?php echo plugins_url('MyContentCreatorPro/assets/img/smallpdf.png'); ?>" width="24" height="24" alt="small pdf share "/></a>
				<a target="_blank" href="https://pt.scribd.com/upload-document/"><img style="vertical-align: inherit;" src="<?php echo plugins_url('MyContentCreatorPro/assets/img/scribd.png'); ?>" width="24" height="24" alt="scribd pdf share "/></a>
			    <a target="_blank" href="https://twitter.com/intent/tweet?ref_src=<?php echo $pdf_link; ?>&text=<?php echo get_the_title(); ?>&tw_p=tweetbutton&url=<?php echo $pdf_link; ?>" data-size="large"><i class="fa fa-twitter-square" style="font-size:30px"></i></a>
			    <a target="_blank" href="https://pinterest.com/pin/create/button/?url=<?php echo $pdf_link; ?>&media=<?php echo $image[0]; ?>&description=<?php the_title();?>"><i class="fa fa-pinterest-square" style="font-size:30px"></i></a>
			    <a target="_blank" href="https://www.linkedin.com/shareArticle?mini=true&url=<?php echo $pdf_link; ?>&submitted-image-url=<?php echo $image[0]; ?>"><i class="fa fa-linkedin-square" style="font-size:30px"></i></a>
     		</td>
			
			<?php }else{ ?>
			<td>N/A</td>
			<td>N/A</td>
			<td>N/A</td>
			<?php } ?>
            <td>
				<div id="popup<?php echo $a; ?>" class="overlay">
					<div class="popup">
						<h2>Link Settings </h2>
						<a class="close" href="#">&times;</a>
						<form>
						    <div class="row">
								<div class="col-md-2">
									<label for="pdf_link">Enter Link</label>
								</div>
								<div class="col-md-9">
									<input type="text" class="form-control pdf_link" id="pdf_link_<?php echo $a; ?>" value="" placeholder="Enter Link..." required />
								</div>
							</div>
							<div class="row">
								<div class="col-md-2">
									<label for="pdf_link_text">Link Text</label>
								</div>
								<div class="col-md-9">
									<input type="text" class="form-control" id="pdf_link_text_<?php echo $a; ?>" value="" placeholder="Enter Link Text..." required />
								</div>
							</div>
							<div class="row">
								<div class="col-md-2">
									<label for="pdf_link_text">Link Position</label>
								</div>
								<div class="col-md-9">
									<input type="checkbox" class="pdf_position_<?php echo $a; ?>" id="pdf_position1" name="pdf_position[<?php echo $a; ?>]" value="top"> Top<br>
								    <input type="checkbox" class="pdf_position_<?php echo $a; ?>" id="pdf_position2" name="pdf_position[<?php echo $a; ?>]" value="middle"> Middle<br>
								    <input type="checkbox" class="pdf_position_<?php echo $a; ?>" id="pdf_position3" name="pdf_position[<?php echo $a; ?>]" value="bottom"> Bottom
								</div>
							</div>
							<div class="row">
								<div class="col-md-2">
									<label for="pdf_link_text"></label>
								</div>
								<div class="col-md-9">
									<input type="button" class="btn_spin_pdf btn_pdf_link_download" data-id="<?php echo $a; ?>" data-pid="<?php echo get_the_id(); ?>" value="Download" />
								</div>
							</div>
						</form>	
					</div>
				</div>
				<a class="btn_spin_pdf" href="#popup<?php echo $a; ?>">Generate PDF</a>
            </td>
        </tr>
        <?php
        $a++;
        endwhile;
        if (function_exists("pagination_ch")) 
        {
          pagination_ch($result->max_num_pages,$paged);
        }  
        endif; 
        ?>
      </tbody>
    </table>
</div>
</div>

<script>
jQuery(document).ready(function($){
	$('.btn_pdf_link_download').click(function(){		
		var ajaxurl = "<?php echo admin_url('admin-ajax.php'); ?>";
		var id = $(this).data('id');
		var pid = $(this).data('pid');
		var pdf_link = $("#pdf_link_"+id).val();
		var link_text = $("#pdf_link_text_"+id).val();
		
		/* var pdf_position = $("input[name='pdf_position']:checked").val();
		if(!pdf_position){
			var pdf_position ='top';
		} */
		var pdf_position = [];
        $('.pdf_position_'+id+':checked').each(function(i){
          pdf_position[i] = $(this).val();
        });
		var pdf_content = $("#article_messages").val();

		var pdf_data_search = {
			action: 'pdf_link_result',
			ch_pdf_id : id,
			ch_pdf_pid : pid,
			ch_pdf_link : pdf_link,
			ch_link_text : link_text,
			ch_pdf_position : pdf_position,
			ch_pdf_content : pdf_content,
		};
		$.post(ajaxurl, pdf_data_search, function(ch_response) 
		{
			$("#popup2").html(ch_response);	
		});
	});
});
</script>