<?php
/**
 * Enqueue Scripts
 *
 * @package    ChatGPT-OpenAI Content Generator
 * @author     JH Fahim 
 * @license    GNU General Public License, version 3
 */
if ( ! defined( 'ABSPATH' ) ) {
   exit;
}
class mych_ChatGPT_Wp_Scripts {

   /**
	 * Initialize scripts
	 *
	 * @access public
	 * @return void
	 */
	public function __construct() {
		
		add_action( 'wp_enqueue_scripts', array( $this, 'cicg_chatgpt_wp_enqueue_scripts' ) );
      
	}

	/**
	 * Loads css files
	 *
	 * @access public
	 * @return void
	 */

	 public function cicg_chatgpt_wp_enqueue_scripts(){
     // Get the URL to the root directory of the plugin
    $plugin_url = plugin_dir_url(dirname(__FILE__, 3));
		wp_enqueue_style( 'cicg-deshboard-style', $plugin_url . 'cicg-chatgpt-openai-content-generator/assets/css/cicg-style.css', array(), '1.0.0' );
		wp_enqueue_script('cicg-chatgpt-script', $plugin_url . 'cicg-chatgpt-openai-content-generator/assets/js/cicg-custom.js', array('jquery'), '1.0.0',true );
		// Localize the script with the input value
		wp_localize_script('cicg-chatgpt-script', 'chatgpt_settings_data', array(
			'chatgpt_api_key' => esc_attr( get_option('cicg_chatgpt_api_key') ),
			'chatgpt_api_max_tokens' => esc_attr(get_option('cicg_chatgpt_api_max_tokens')),
			'api_temperature' => esc_attr( get_option('cicg_api_temperature') )
		 ));
	 }

}
new mych_ChatGPT_Wp_Scripts();