<?php
class channelapi
{
	private $db;
	function __construct() 
	{
		$this->db = $GLOBALS['wpdb'];
	}

	public function channel_list($channel_query_id)
	{		
		$mych_channel_ytube_api = get_option('wpch_ytube_api_key');
		if(!empty($channel_query_id) && !empty($mych_channel_ytube_api))
		{
			$mych_channel_api = 'https://youtube.googleapis.com/youtube/v3/search?part=snippet&channelType=any&maxResults=50&order=title&q='.urlencode($channel_query_id).'&type=channel&videoCaption=any&key='.$mych_channel_ytube_api;

			$ch = curl_init();

			curl_setopt($ch, CURLOPT_HEADER, 0);
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
			curl_setopt($ch, CURLOPT_URL, $mych_channel_api);
			curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
			curl_setopt($ch, CURLOPT_VERBOSE, 0);
			curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
			$mych_channel_response = curl_exec($ch);

			curl_close($ch);
			$mych_channel_data = json_decode($mych_channel_response);
			
			$mych_channel_response = json_decode(json_encode($mych_channel_data), true);			
			
			if(!empty($mych_channel_response['pageInfo']['totalResults']))
			{
				$mych_channel_page_totalresult = $mych_channel_response['pageInfo']['totalResults'];
			}
						
			if(!empty($mych_channel_response['items']))	
			{				
				foreach ($mych_channel_response['items'] as $mych_channel_key_resp1) 
				{		
					if ($mych_channel_key_resp1['id']['kind'] == "youtube#channel") 
					{
						$mych_channel_title = stripslashes(str_replace('"','`',$mych_channel_key_resp1['snippet']['channelTitle']));
						
						$mych_channel_id = $mych_channel_key_resp1['id']['channelId'];
						
						$mych_channel_desc = stripslashes(str_replace('"','`',$mych_channel_key_resp1['snippet']['description']));
						
						$mych_channel_img = $mych_channel_key_resp1['snippet']['thumbnails']['default']['url'];
						$mych_channel_link_arr=array('title'=>$mych_channel_title,'desc'=>$mych_channel_desc,'channel_id'=>$mych_channel_id,'thum_img_url'=>$mych_channel_img);
						
						if($channel_query_id)
						{
							$mych_channel_result_output_arr1[] = array('channel-detail'=>$mych_channel_link_arr);
						}	
					}
				}	
			}	
			if(!empty($mych_channel_response['nextPageToken']))
			{
				$mych_channel_page_token = $mych_channel_response['nextPageToken'];
				$mych_channel_result_output_arr2 = $this->channel_list_page_token($channel_query_id,$mych_channel_page_token);
				$mych_channel_result_output = array_merge($mych_channel_result_output_arr1,$mych_channel_result_output_arr2);
			}
			else
			{
				if(!empty($mych_channel_result_output_arr1))
				{
					$mych_channel_result_output = $mych_channel_result_output_arr1;
				}
				else
				{
					$mych_channel_result_output = "";
				}
			}			
		}	
		else
		{
			$mych_channel_result_output = "";
		}
		
		return $mych_channel_result_output;
	}				

	private function channel_list_page_token($channel_query_id1,$channel_page_token1)
	{		
		$mych_channel_ytube_api1 = get_option('wpch_ytube_api_key');
		if(!empty($channel_query_id1) && !empty($channel_page_token1) && !empty($mych_channel_ytube_api1))
		{
			$mych_channel_api1 = 'https://youtube.googleapis.com/youtube/v3/search?part=snippet&channelType=any&maxResults=50&order=title&q=' .urlencode($channel_query_id1). '&type=channel&videoCaption=any&key='.$mych_channel_ytube_api1.'&pageToken=' . $channel_page_token1;

			$ch = curl_init();

			curl_setopt($ch, CURLOPT_HEADER, 0);
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
			curl_setopt($ch, CURLOPT_URL, $mych_channel_api1);
			curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
			curl_setopt($ch, CURLOPT_VERBOSE, 0);
			curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
			$mych_channel_response1 = curl_exec($ch);

			curl_close($ch);
			$mych_channel_data1 = json_decode($mych_channel_response1);
			
			$mych_channel_response1 = json_decode(json_encode($mych_channel_data1), true);
			
			if(!empty($mych_channel_response1['nextPageToken']))
			{
				$mych_channel_page_token1 = $mych_channel_response1['nextPageToken'];
			}
			
			foreach ($mych_channel_response1['items'] as $mych_channel_key_resp11) 
			{		
				if ($mych_channel_key_resp11['id']['kind'] == "youtube#channel") 
				{
					$mych_channel_title1 = stripslashes(str_replace('"','`',$mych_channel_key_resp11['snippet']['channelTitle']));
					
					$mych_channel_id1 = $mych_channel_key_resp11['id']['channelId'];
					
					$mych_channel_desc1 = stripslashes(str_replace('"','`',$mych_channel_key_resp11['snippet']['description']));
					
					$mych_channel_img1 = $mych_channel_key_resp11['snippet']['thumbnails']['default']['url'];
					$mych_channel_link_arr1=array('title'=>$mych_channel_title1,'desc'=>$mych_channel_desc1,'channel_id'=>$mych_channel_id1,'thum_img_url'=>$mych_channel_img1);
					
					if($channel_query_id1)
					{
						$mych_channel_result_output1[] = array('channel-detail'=>$mych_channel_link_arr1);
					}	
				}
			}
		}	
		else
		{
			$mych_channel_result_output1 = "";
		}
		
		return $mych_channel_result_output1;
	}				
	
	public function channel_detail($channel_id)
	{		
		$mych_channel_ytube_api = get_option('wpch_ytube_api_key');
		if(!empty($channel_id) && !empty($mych_channel_ytube_api))
		{
			$mych_channel_api_detail = 'https://www.googleapis.com/youtube/v3/channels?id='.$channel_id.'&key='.$mych_channel_ytube_api.'&part=contentDetails,snippet';
			
			$ch = curl_init();

			curl_setopt($ch, CURLOPT_HEADER, 0);
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
			curl_setopt($ch, CURLOPT_URL, $mych_channel_api_detail);
			curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
			curl_setopt($ch, CURLOPT_VERBOSE, 0);
			curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
			$mych_channel_response_detail = curl_exec($ch);

			curl_close($ch);
			$mych_channel_data_detail = json_decode($mych_channel_response_detail);
			
			$mych_channel_response_details = json_decode(json_encode($mych_channel_data_detail), true);			
			
			foreach ($mych_channel_response_details['items'] as $mych_channel_key_resp1_detail) 
			{		
				if ($mych_channel_key_resp1_detail['kind'] == "youtube#channel") 
				{
					$mych_channel_title_detail = stripslashes(str_replace('"','`',$mych_channel_key_resp1_detail['snippet']['title']));
					
					$mych_channel_id_detail = $mych_channel_key_resp1_detail['id'];
					
					$mych_channel_desc_detail = stripslashes(str_replace('"','`',$mych_channel_key_resp1_detail['snippet']['description']));
					
					$mych_channel_img_detail = $mych_channel_key_resp1_detail['snippet']['thumbnails']['default']['url'];
					$mych_channel_link_arr_detail=array('title'=>$mych_channel_title_detail,'desc'=>$mych_channel_desc_detail,'channel_id'=>$mych_channel_id_detail,'thum_img_url'=>$mych_channel_img_detail);
					
					if($channel_id)
					{
						$mych_channel_result_output_arr1_detail[] = array('channel-detail'=>$mych_channel_link_arr_detail);
					}	
				}
			}				
		}	
		else
		{
			$mych_channel_result_output_arr1_detail = "";
		}
		
		return $mych_channel_result_output_arr1_detail;
	}				
	
	public function youtube_search($channel_id, $next_page_token)
	{	
		$mych_channel_ytube_api = get_option('wpch_ytube_api_key');
		//$mych_channel_ytube_api = 'AIzaSyCiomcpDbV8jBVu2YpOC8dcYpA_JFaqmrw';
		if(!empty($mych_channel_ytube_api))
		{
			$mych_channel_api_detail = 'https://www.googleapis.com/youtube/v3/search?key='.$mych_channel_ytube_api.'&channelId='.$channel_id.'&part=snippet,id&order=date&maxResults=50&pageToken='.$next_page_token;
			
			$ch = curl_init();

			curl_setopt($ch, CURLOPT_HEADER, 0);
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
			curl_setopt($ch, CURLOPT_URL, $mych_channel_api_detail);
			curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
			curl_setopt($ch, CURLOPT_VERBOSE, 0);
			curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
			$mych_channel_response_detail = curl_exec($ch);

			curl_close($ch);
			$data  = json_decode($mych_channel_response_detail);			
			if(!empty($data->nextPageToken))
			{					
				$mych_pagetoken = $data->nextPageToken;
			}
			else
			{
				$mych_pagetoken = '';
			}
			
			/*
			if(!empty($data->nextPageToken))
			{
				$mych_pagetoken = $data->nextPageToken.'--';
				$mych_pagetoken .= $this->youtube_search($mych_channel_ytube_api, $channel_id, $data->nextPageToken);
			}
			*/	
		}
		return $mych_pagetoken;	
	}

	public function youtube_search1($channel_id, $next_page_token)
	{	
		$mych_channel_ytube_api = get_option('wpch_ytube_api_key');
		if(!empty($mych_channel_ytube_api))
		{
			$mych_channel_api_detail = 'https://www.googleapis.com/youtube/v3/search?key='.$mych_channel_ytube_api.'&channelId='.$channel_id.'&part=snippet,id&order=date&maxResults=50&pageToken='.$next_page_token;
			
			$ch = curl_init();

			curl_setopt($ch, CURLOPT_HEADER, 0);
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
			curl_setopt($ch, CURLOPT_URL, $mych_channel_api_detail);
			curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
			curl_setopt($ch, CURLOPT_VERBOSE, 0);
			curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
			$mych_channel_response_detail = curl_exec($ch);

			curl_close($ch);
			$data  = json_decode($mych_channel_response_detail);			
			if(!empty($data->nextPageToken))
			{					
				$mych_pagetoken = $data->nextPageToken;
			}
			else
			{
				$mych_pagetoken = '';
			}
						
			/*			
			if(!empty($data->nextPageToken))
			{
				$mych_pagetoken = $data->nextPageToken.'--';
				$mych_pagetoken .= $this->youtube_search($mych_channel_ytube_api, $channel_id, $data->nextPageToken);
			}
			*/
			
		}
		return $mych_pagetoken;	
	}

	public function youtube_search2($channel_id, $next_page_token)
	{	
		$mych_channel_ytube_api = get_option('wpch_ytube_api_key');
		if(!empty($mych_channel_ytube_api))
		{
			$mych_channel_api_detail = 'https://www.googleapis.com/youtube/v3/search?key='.$mych_channel_ytube_api.'&channelId='.$channel_id.'&part=snippet,id&order=date&maxResults=50&pageToken='.$next_page_token;
			
			$ch = curl_init();

			curl_setopt($ch, CURLOPT_HEADER, 0);
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
			curl_setopt($ch, CURLOPT_URL, $mych_channel_api_detail);
			curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
			curl_setopt($ch, CURLOPT_VERBOSE, 0);
			curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
			$mych_channel_response_detail = curl_exec($ch);

			curl_close($ch);
			$data  = json_decode($mych_channel_response_detail);	
			if(!empty($data->nextPageToken))
			{					
				$mych_pagetoken = $data->nextPageToken;
			}
			else
			{
				$mych_pagetoken = '';
			}
			/*
			if(!empty($data->nextPageToken))
			{
				$mych_pagetoken = $data->nextPageToken.'--';
				$mych_pagetoken .= $this->youtube_search($mych_channel_ytube_api, $channel_id, $data->nextPageToken);
			}
			*/			
		}
		return $mych_pagetoken;	
	}

	public function youtube_search3($channel_id, $next_page_token)
	{	
		$mych_channel_ytube_api = get_option('wpch_ytube_api_key');
		if(!empty($mych_channel_ytube_api))
		{
			$mych_channel_api_detail = 'https://www.googleapis.com/youtube/v3/search?key='.$mych_channel_ytube_api.'&channelId='.$channel_id.'&part=snippet,id&order=date&maxResults=50&pageToken='.$next_page_token;
			
			$ch = curl_init();

			curl_setopt($ch, CURLOPT_HEADER, 0);
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
			curl_setopt($ch, CURLOPT_URL, $mych_channel_api_detail);
			curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
			curl_setopt($ch, CURLOPT_VERBOSE, 0);
			curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
			$mych_channel_response_detail = curl_exec($ch);

			curl_close($ch);
			$data  = json_decode($mych_channel_response_detail);			
			if(!empty($data->nextPageToken))
			{					
				$mych_pagetoken = $data->nextPageToken;
			}
			else
			{
				$mych_pagetoken = '';
			}
			
			/*
			if(!empty($data->nextPageToken))
			{
				$mych_pagetoken = $data->nextPageToken.'--';
				$mych_pagetoken .= $this->youtube_search($mych_channel_ytube_api, $channel_id, $data->nextPageToken);
			}
			*/			
		}
		return $mych_pagetoken;	
	}
	
	
	public function channel_video_list($channel_id,$page_token)
	{		
		$mych_channel_ytube_api = get_option('wpch_ytube_api_key');
		if(!empty($channel_id) && !empty($mych_channel_ytube_api))
		{
			$mych_channel_api_detail = 'https://www.googleapis.com/youtube/v3/search?key='.$mych_channel_ytube_api.'&channelId='.$channel_id.'&part=snippet,id&order=date&maxResults=50&pageToken='.$page_token;
			
			$ch = curl_init();

			curl_setopt($ch, CURLOPT_HEADER, 0);
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
			curl_setopt($ch, CURLOPT_URL, $mych_channel_api_detail);
			curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
			curl_setopt($ch, CURLOPT_VERBOSE, 0);
			curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
			$mych_channel_response_detail = curl_exec($ch);

			curl_close($ch);
			$mych_channel_data_detail = json_decode($mych_channel_response_detail);			
			$mych_channel_response_details = json_decode(json_encode($mych_channel_data_detail), true);			
			
			foreach ($mych_channel_response_details['items'] as $mych_channel_key_resp1_detail) 
			{						
				if ($mych_channel_key_resp1_detail['kind'] == "youtube#searchResult") 
				{
					if(!empty($mych_channel_key_resp1_detail['id']['videoId']))
					{
						$video_id = $mych_channel_key_resp1_detail['id']['videoId'];
					}
					else
					{
						$video_id = '';
					}
					$mych_channel_published = stripslashes(str_replace('"','`',$mych_channel_key_resp1_detail['snippet']['publishedAt']));
					$mych_channel_title_detail = stripslashes(str_replace('"','`',$mych_channel_key_resp1_detail['snippet']['title']));
										
					$mych_channel_desc_detail = stripslashes(str_replace('"','`',$mych_channel_key_resp1_detail['snippet']['description']));
					
					$mych_channel_img_detail = $mych_channel_key_resp1_detail['snippet']['thumbnails']['default']['url'];
					$mych_channel_link_arr_detail=array('vid_id'=>$video_id,'published_time'=>$mych_channel_published,'title'=>$mych_channel_title_detail,'desc'=>$mych_channel_desc_detail,'thum_img_url'=>$mych_channel_img_detail);
					
					$mych_channel_result_output_arr1_detail[] = array('channel-detail'=>$mych_channel_link_arr_detail);
				}
			}				
		}	
		else
		{
			$mych_channel_result_output_arr1_detail = "";
		}
		
		return $mych_channel_result_output_arr1_detail;
	}				
	
	public function channel_video_detail($video_id)
	{		
		$mych_channel_ytube_api = get_option('wpch_ytube_api_key');
		if(!empty($channel_id) && !empty($mych_channel_ytube_api))
		{
			$mych_channel_api_detail = 'https://www.googleapis.com/youtube/v3/videos?key='.$mych_channel_ytube_api.'&id='.$video_id.'&part=snippet,id';
			
			$ch = curl_init();

			curl_setopt($ch, CURLOPT_HEADER, 0);
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
			curl_setopt($ch, CURLOPT_URL, $mych_channel_api_detail);
			curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
			curl_setopt($ch, CURLOPT_VERBOSE, 0);
			curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
			$mych_channel_response_detail = curl_exec($ch);

			curl_close($ch);
			$mych_channel_data_detail = json_decode($mych_channel_response_detail);			
			$mych_channel_response_details = json_decode(json_encode($mych_channel_data_detail), true);			
			
			foreach ($mych_channel_response_details['items'] as $mych_channel_key_resp1_detail) 
			{						
				if ($mych_channel_key_resp1_detail['kind'] == "youtube#video") 
				{
					$mych_channel_title_detail = stripslashes(str_replace('"','`',$mych_channel_key_resp1_detail['snippet']['title']));
										
					$mych_channel_desc_detail = stripslashes(str_replace('"','`',$mych_channel_key_resp1_detail['snippet']['description']));
					
					$mych_channel_img_detail = $mych_channel_key_resp1_detail['snippet']['thumbnails']['default']['url'];
					$mych_channel_link_arr_detail=array('title'=>$mych_channel_title_detail,'desc'=>$mych_channel_desc_detail,'thum_img_url'=>$mych_channel_img_detail);					
					$mych_channel_result_output_arr1_detail[] = array('channel-detail'=>$mych_channel_link_arr_detail);
				}
			}				
		}	
		else
		{
			$mych_channel_result_output_arr1_detail = "";
		}
		
		return $mych_channel_result_output_arr1_detail;
	}				
	
	public function channel_ezine_category()
	{		
		$api_key = get_option('wpch_ezinearticle_app_key');
		$category='';

		if(!empty($api_key)){
            $url='http://api.ezinearticles.com/api.php?search=categories&category=&response_format=json&key='.$api_key;            
			$ch = curl_init($url);
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
			curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
			curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
			curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
			$data = curl_exec($ch);
			curl_close($ch);
            $categories1 = json_decode($data);
			if(!empty($categories1->categories))
			{		
				$category = $categories1->categories;
			}
		}
		
		return $category;
	}				
	
	public function channel_ezine_articles($catid)
	{
		$api_key = get_option('wpch_ezinearticle_app_key');

		if(!empty($api_key)){
            $url='http://api.ezinearticles.com/api.php?search=articles&category='.$catid.'&response_format=json&key='.$api_key;
			$ch = curl_init($url);
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
			curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
			curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
			curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
			$data = curl_exec($ch);
			curl_close($ch);
            $mych_ezine_article_result1 = json_decode($data);
			$mych_ezine_article_result = $mych_ezine_article_result1->articles;
		}
		
		return $mych_ezine_article_result;
	}

	public function article_forge_ref_id($channel_query_result,$subkey_updated)
	{
		$result_article_forge_enable = get_option('wpch_articleforge_enable');
		$api_key = get_option('wpch_articleforge_app_key');

		$result_article_forge_title = get_option('wpch_articleforge_title');
		$result_article_forge_image = get_option('wpch_articleforge_image');
		$result_article_forge_sub_keyword = '';
		$result_article_forge_content_length = get_option('wpch_articleforge_length');


		if(!empty($channel_query_result))
		{
			$valueforvar1 = $channel_query_result;
		}

		if(!empty($subkey_updated))
		{
			$valueforvar2 = $subkey_updated;
		}
		else
		{
			$valueforvar2 = '';	
		}

		if(!empty($result_article_forge_title) && $result_article_forge_title == 'on')
		{
			$valueforvar3 = '1';
		} 
		else 
		{
			$valueforvar3 = '0';
		}
		if(!empty($result_article_forge_image) && $result_article_forge_image == 'on')
		{
			$valueforvar4 = '1.00';
		} 
		else 
		{
			$valueforvar4 = '0.00';
		}
		if(!empty($result_article_forge_content_length))
		{
			$valueforvar5 = $result_article_forge_content_length;	
			if($result_article_forge_content_length == 'very_long')
			{
				$valueforvar6 = '1';	
			}
			else
			{
				$valueforvar6 = '0';	
			}
		}
		else
		{
			$valueforvar5 = 'short';	
		}
		
		if(!empty($result_article_forge_content_length) && $result_article_forge_content_length == 'very_long')
		{
			$valueforvar6 = '1';	
		}
		else
		{
			$valueforvar6 = '0';	
		}

		if(!empty($api_key) && !empty($valueforvar1))
		{
			$ch = curl_init('https://af.articleforge.com/api/initiate_article');
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
			curl_setopt ($ch, CURLOPT_POST, 1);
			curl_setopt ($ch, CURLOPT_POSTFIELDS,
			"key=$api_key&keyword=$valueforvar1&sub_keywords=$valueforvar2&title=$valueforvar3&image=$valueforvar4&length=$valueforvar5&use_section_heading=$valueforvar6&turing_spinner=0");
			$result = curl_exec($ch);
			curl_close ($ch);

			$result_resp = json_decode($result);
			if(!empty($result_resp->ref_key))
			{
				$result_ref = $result_resp->ref_key; 
			}
			else
			{
				$result_ref = '';					
			}
			
			return $result_ref;
		}
	}
	
	public function article_forge_ref_id_new($channel_query_result,$result_article_forge_sub_keyword,$result_article_forge_title,$result_article_forge_image,$result_article_forge_video,$result_article_forge_content_length,$result_article_forge_sheading,$section_headings_all)
	{
		$api_key = get_option('wpch_articleforge_app_key');
		
		if(!empty($channel_query_result))
		{
			$valueforvar1 = $channel_query_result;
		}

		if(!empty($result_article_forge_sub_keyword))
		{
			$valueforvar2 = $result_article_forge_sub_keyword;
		}
		
		/*
		if(!empty($result_article_forge_title) && $result_article_forge_title == 'on')
		{
			$valueforvar3 = '1';
		} 
		else 
		{
			$valueforvar3 = '0';
		}
		*/
		
		$valueforvar3 = '1';
		
		if(!empty($result_article_forge_image) && $result_article_forge_image == 'on')
		{
			$valueforvar4 = '1.00';
		} 
		else 
		{
			$valueforvar4 = '0.00';
		}
		if(!empty($result_article_forge_video) && $result_article_forge_video == 'on')
		{
			$valueforvar_video = '1.00';
		} 
		else 
		{
			$valueforvar_video = '0.00';
		}
				
		if(!empty($result_article_forge_content_length))
		{
			$valueforvar5 = $result_article_forge_content_length;	
			if($result_article_forge_content_length == 'very_long')
			{
				$valueforvar6 = '1';	
			}
			else
			{
				if(!empty($result_article_forge_title) && $result_article_forge_title == 'on')
				{
					$valueforvar6 = '1';
				} 
				else 
				{
					if(!empty($result_article_forge_sheading) && $result_article_forge_sheading == 'on')
					{
						$valueforvar6 = '1';
					} 
					else 
					{
						$valueforvar6 = '0';
					}
				}
			}
		}
		else
		{
			$valueforvar5 = 'medium';	
		}
		
		if(!empty($result_article_forge_content_length) && $result_article_forge_content_length == 'very_long')
		{
			$valueforvar6 = '1';	
		}
		else
		{
			if(!empty($result_article_forge_sheading) && $result_article_forge_sheading == 'on')
			{
				$valueforvar6 = '1';
			} 
			else 
			{
				$valueforvar6 = '0';
			}
		}

		if(!empty($api_key) && !empty($valueforvar1))
		{
			$ch = curl_init('https://af.articleforge.com/api/initiate_article');
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
			curl_setopt ($ch, CURLOPT_POST, 1);
			curl_setopt ($ch, CURLOPT_POSTFIELDS,
			"key=$api_key&keyword=$valueforvar1&sub_keywords=$valueforvar2&title=$valueforvar3&image=$valueforvar4&video=$valueforvar_video&length=$valueforvar5&use_section_heading=$valueforvar6&section_headings=$section_headings_all");
			$result = curl_exec($ch);
			curl_close ($ch);

			$result_resp = json_decode($result);			
			if($result_resp->status == 'Fail')
			{
				$result_ref = $result_resp->error_message;
			}
			else
			{
				if(!empty($result_resp->ref_key))
				{
					$result_ref = $result_resp->ref_key; 
				}
				else
				{
					$result_ref = '';					
				}
			}
			
			return $result_ref;			
		}
	}
	
	public function article_forge_result($ref_id)
	{
		$result_article_forge_enable1 = get_option('wpch_articleforge_enable');

		if(!empty($result_article_forge_enable1) && $result_article_forge_enable1 == 'on')
		{
			if(!empty($ref_id))
			{
				$api_key = get_option('wpch_articleforge_app_key');
				if(!empty($api_key))
				{
					$ch = curl_init('https://af.articleforge.com/api/view_article');
					curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
					curl_setopt ($ch, CURLOPT_POST, 1);
					curl_setopt ($ch, CURLOPT_POSTFIELDS,
					"key=$api_key&article_id=$ref_id");
					$result = curl_exec($ch);
					curl_close ($ch);

					$result_resp = json_decode($result);
					if(!empty($result_resp->data))
					{
						$result_article = $result_resp->data;	
					}
					else
					{
						$result_article = '';	
					}
				}
			}
		}
		
		return $result_article;
	}
	
	
	public function fnextractHeadins($headingtag, $html)
	{
		$headingText = '';
		preg_match_all( '|<'.$headingtag.'>(.*)</'.$headingtag.'>|iU', $html, $headings );
		foreach($headings[0] as $headh2val)
		{
			$headingText.=$headh2val;
		}
		return $headingText;
	}

	public function article_forge_result_new($ref_id)
	{
		if(!empty($ref_id))
		{
			$api_key = get_option('wpch_articleforge_app_key');
			if(!empty($api_key))
			{
				$ch = curl_init('https://af.articleforge.com/api/view_article');
				curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
				curl_setopt ($ch, CURLOPT_POST, 1);
				curl_setopt ($ch, CURLOPT_POSTFIELDS,
				"key=$api_key&article_id=$ref_id");
				$result = curl_exec($ch);
				curl_close ($ch);

				$result_resp = json_decode($result);
				if(!empty($result_resp->data))
				{
					$result_article = $result_resp->data;	
				}
				else
				{
					$result_article = '';	
				}
			}
		}
		
		return $result_article;
	}
}


?>